/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */

package result

// GetFleetRoleCredentialsResult - AWS credentials for API authentication.
// The service role credentials provided to GameLift that allow compute access
// to other AWS services in your account.
type GetFleetRoleCredentialsResult struct {
	// The Amazon Resource Name (ARN) of the user that the service role belongs to.
	AssumedRoleUserArn string `json:"AssumedRoleUserArn"`
	// A unique identifier that contains the role ID and the role session name of the role that is being assumed.
	// The role ID is generated by AWS when the role is created.
	// Length Constraints: Minimum length of 2. Maximum length of 193.
	AssumedRoleID string `json:"AssumedRoleId"`
	// The access key ID that identifies the temporary security credentials.
	// Length Constraints: Minimum length of 16. Maximum length of 128.
	AccessKeyID string `json:"AccessKeyId"`
	// The secret access key that can be used to sign requests.
	SecretAccessKey string `json:"SecretAccessKey"`
	// The token that users must pass to the service API to use the temporary credentials.
	SessionToken string `json:"SessionToken"`
	// The date on which the current credentials expire.
	Expiration int64 `json:"Expiration"`
}
