﻿/*
* All or portions of this file Copyright (c) Amazon.com, Inc. or its affiliates or
* its licensors.
*
* For complete copyright and license terms please see the LICENSE at the root of this
* distribution (the "License"). All use of this software is governed by the License,
* or, if provided, by the license below or the license accompanying this file. Do not
* remove or modify any license notices. This file is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*
*/

using System.Collections.Generic;

namespace Aws.GameLift.Server
{
    /// <summary>
    /// This data type is used to identify which files generated during a 
    /// game session that you want GameLift to upload and store once the 
    /// game session ends. This information is communicated to GameLift in a 
    /// ProcessReady() call.
    /// </summary>
    public class LogParameters
    {
        /// <summary>
        /// List of directory paths to game server log files you want GameLift 
        /// to store for future access. These files are generated by a server 
        /// process during each game session; file paths and names are defined 
        /// in your game server and stored in the root game build directory. 
        /// The log paths must be absolute.<br/>
        /// For example, if your game build stores game session logs in a path 
        /// like <c>MyGame\sessionlogs\</c>, then the log path would be 
        /// <c>c:\game\MyGame\sessionLogs</c> (on a Windows instance) or 
        /// <c>/local/game/MyGame/sessionLogs</c> (on a Linux instance). 
        /// </summary>
        public List<string> LogPaths { get; set; }

        public LogParameters()
        {
            LogPaths = new List<string>();
        }

        public LogParameters(List<string> logPaths)
        {
            LogPaths = logPaths;
        }
    }
}
